

PROCEDURE THREEOPT(
       N      :INTEGER;
   VAR W      :ARRNN;
   VAR ROUTE  :ARRN;
   VAR TWEIGHT:INTEGER);

   TYPE SWAPTYPE  =(ASYMMETRIC,SYMMETRIC);
        SWAPRECORD=RECORD
                      X1,X2,Y1,Y2,Z1,Z2,GAIN:INTEGER;
                      CHOICE                :SWAPTYPE
                   END;
   VAR BESTSWAP,SWAP:SWAPRECORD;
       I,INDEX,J,K  :INTEGER;
       PTR          :ARRN;

   PROCEDURE SWAPCHECK(VAR SWAP:SWAPRECORD);
      VAR DELWEIGHT,MAX:INTEGER;
   BEGIN
      WITH SWAP DO BEGIN
         GAIN:=0;
         DELWEIGHT:=W[X1,X2]+W[Y1,Y2]+W[Z1,Z2];
         MAX:=DELWEIGHT-(W[Y1,X1]+W[Z1,X2]+W[Z2,Y2]);
         IF MAX > GAIN THEN BEGIN
            GAIN:=MAX;  CHOICE:=ASYMMETRIC
         END;
         MAX:=DELWEIGHT-(W[X1,Y2]+W[Z1,X2]+W[Y1,Z2]);
         IF MAX > GAIN THEN BEGIN
            GAIN:=MAX;  CHOICE :=SYMMETRIC
         END
      END  { WITH SWAP }
   END;  { SWAPCHECK }

   PROCEDURE REVERSE(START,FINISH:INTEGER);
      VAR AHEAD,LAST,NEXT:INTEGER;
   BEGIN
      IF START <> FINISH THEN BEGIN
         LAST:=START;  NEXT:=PTR[LAST];
         REPEAT
            AHEAD:=PTR[NEXT];  PTR[NEXT]:=LAST;
            LAST:=NEXT;  NEXT:=AHEAD;
         UNTIL LAST = FINISH
      END  { IF START <> FINISH }
   END;  { RESERVE }

BEGIN                                                   { MAIN BODY }
   FOR I:=1 TO N-1 DO PTR[ROUTE[I]]:=ROUTE[I+1];
   PTR[ROUTE[N]]:=ROUTE[1];
   REPEAT  { UNTIL BESTSWAP.GAIN = 0 }
      BESTSWAP.GAIN:=0;
      SWAP.X1:=1;
      FOR I:=1 TO N DO BEGIN
         SWAP.X2:=PTR[SWAP.X1];  SWAP.Y1:=SWAP.X2;
         FOR J:=2 TO N-3 DO BEGIN
            SWAP.Y2:=PTR[SWAP.Y1];  SWAP.Z1:=PTR[SWAP.Y2];
            FOR K:=J+2 TO N-1 DO BEGIN
               SWAP.Z2:=PTR[SWAP.Z1];
               SWAPCHECK(SWAP);
               IF SWAP.GAIN > BESTSWAP.GAIN THEN BESTSWAP:=SWAP;
               SWAP.Z1:=SWAP.Z2
            END;  { FOR K }
            SWAP.Y1:=SWAP.Y2
         END;  { FOR J }
         SWAP.X1:=SWAP.X2
      END;  { FOR I }
      IF BESTSWAP.GAIN > 0 THEN
         WITH BESTSWAP DO BEGIN
            IF CHOICE = ASYMMETRIC THEN BEGIN
               REVERSE(Z2,X1);
               PTR[Y1]:=X1;  PTR[Z2]:=Y2
            END
            ELSE BEGIN
               PTR[X1]:=Y2;  PTR[Y1]:=Z2
            END;
            PTR[Z1]:=X2;
            TWEIGHT:=TWEIGHT-GAIN
         END  { WITH BESTSWAP }
   UNTIL BESTSWAP.GAIN = 0;
   INDEX:=1;
   FOR I:=1 TO N DO BEGIN
      ROUTE[I]:=INDEX;  INDEX:=PTR[INDEX]
   END
END;  { THREEOPT }

